// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: implenent the attribute/value functions
//
// - Automatic Version Information via RCS:
//   $Id: getattr.cxx,v 1.2 2001/12/19 05:26:56 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/getattr.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "ldapapi.h"
#include <ldap-int.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: getattr.cxx,v 1.2 2001/12/19 05:26:56 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

char * ldap_first_attribute (LDAP *ld, LDAPMessage *entry, BerElement **ber) {
  BerElement *number=new BerElement();
  number->number=0;
  *ber=number;
  return ldap_next_attribute(ld, entry, *ber);
}

char * ldap_next_attribute (LDAP *ld, LDAPMessage *entry, BerElement *ber){
  char *rv;
  if ((NULL==ld)||(NULL==entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  if(!((&entry->message->m_protocolOp.GetObject())->IsClass("LDAP_SearchResponse")  && 
       entry->message->m_protocolOp.GetTag()==LDAP_SearchResponse::e_entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  LDAP_SearchResponse &res=entry->message->m_protocolOp;
  LDAP_SearchResponse_entry &ent=res;
  if (ent.m_attributes.GetSize() <= ber->number) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  rv=strndup((char *)ent.m_attributes[ber->number].m_type.GetPointer(),
	     ent.m_attributes[ber->number].m_type.GetSize());
  ber->number++;
  return rv;
}

char ** ldap_get_values (LDAP *ld, LDAPMessage *entry, LDAP_CONST char *target) {
  unsigned int number;
  if ((NULL==ld)||(NULL==entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  if(!(&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
    LDAP_SearchResponse &res=entry->message->m_protocolOp;
      if(res.GetTag()!=LDAP_SearchResponse::e_entry) {
	ld->ld_errno=LDAP_PARAM_ERROR;
	return NULL;
      }
  }
  LDAP_SearchResponse &res=entry->message->m_protocolOp;
  LDAP_SearchResponse_entry &ent=res;
  for(number=0; 
      strncmp((char *)ent.m_attributes[number].m_type.GetPointer(),target,strlen(target))!=0;
      number++) 
    if (ent.m_attributes.GetSize()<number) {
      ld->ld_errno=LDAP_PARAM_ERROR;
      return NULL;
    }
  LDAP_SearchResponse_entry_attributes_subtype &response=ent.m_attributes[number];
  char **ret=new (char *)[response.m_values.GetSize()+1];
  for (unsigned int i=0; i<response.m_values.GetSize(); i++)
    ret[i]=strndup((char *)response.m_values[i].GetPointer(),
		   response.m_values[i].GetSize());
  ret[response.m_values.GetSize()]=NULL;
  return ret;
}
			  


struct berval ** ldap_get_values_len (LDAP *ld, LDAPMessage *entry, LDAP_CONST char *target){
  unsigned int number;
  if ((NULL==ld)||(NULL==entry)) {
    ld->ld_errno=LDAP_PARAM_ERROR;
    return NULL;
  }
  if(!(&(entry->message->m_protocolOp.GetObject()))->IsClass("LDAP_SearchResponse")) {
    LDAP_SearchResponse &res=entry->message->m_protocolOp;
      if(res.GetTag()!=LDAP_SearchResponse::e_entry) {
	ld->ld_errno=LDAP_PARAM_ERROR;
	return NULL;
      }
  }
  LDAP_SearchResponse &res=entry->message->m_protocolOp;
  LDAP_SearchResponse_entry &ent=res;
  for(number=0; 
      strncmp((char *)ent.m_attributes[number].m_type.GetPointer(),target,strlen(target))!=0;
      number++) {
    if (ent.m_attributes.GetSize()<number) {
      ld->ld_errno=LDAP_PARAM_ERROR;
      return NULL;
    }
  }
  LDAP_SearchResponse_entry_attributes_subtype &response=ent.m_attributes[number];
#ifdef DEBUG
  cerr << response << endl;
#endif
  struct berval **ret=new (struct berval*)[response.m_values.GetSize()+1];
  for (unsigned int i=0; i<response.m_values.GetSize(); i++) {
#ifdef DEBUG
    cerr << "number: " << i << endl;
    cerr << response.m_values[i] << endl;
#endif
    struct berval* bv=new struct berval;
    bv->bv_len=response.m_values[i].GetSize();
    bv->bv_val=strndup((char *)response.m_values[i].GetPointer(),bv->bv_len);
    ret[i]=bv;
  }
  ret[response.m_values.GetSize()]=NULL;
  return ret;
}

int ldap_count_values (char **vals) {
  int number=0;
  while(NULL!=vals[number])
    number++;
  return number;
}

int ldap_count_values_len (struct berval **vals){
  int number=0;
  while(NULL!=vals[number])
    number++;
  return number;
}

//
// End of getattr.cxx
//
