// Copyright (C) 2001 Nils Bokermann <Nils.Bokermann@mediaWays.net>
//
// PURPOSE OF THIS FILE: Implement memory-management functions.
//
// - Automatic Version Information via RCS:
//   $Id: free.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $
//   $Source: /cvsroot/openh323gk/openh323gk/ldap/src/free.cxx,v $
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "ldapapi.h"
#include <ldap-int.h>
#include <vector.h>

#ifndef lint
// mark object with version info
static const char vcid[] = "@(#) $Id: free.cxx,v 1.1 2001/12/17 16:36:17 nilsb Exp $";
static const char vcHid[] = __LDAP_OPENH323_H;
#endif

int ldap_free(LDAP *ld){
  if (ld) {
    delete ld->socket;
    delete ld->ld_options;
    delete ld;
  }
  ld=NULL;
  return 0;
}

int ldap_msgfree(LDAPMessage *msg){
  if(NULL==msg) 
    return 0;
  LDAPMessage *tmp=msg->next;
  int type=0;
  while(tmp) {
    LDAPMessage *a=tmp;
    tmp=tmp->next;
    type=ldap_msgtype(a);
    delete a;
  }
  delete msg;
  msg=NULL;
  return type;
}

void ldap_memfree(char *mem){
  if(mem)
    //    free(mem);
    delete mem;
}

LDAP *ldap_new() {
  LDAP *ld=new struct ldap;
  if(NULL==ld)
    return NULL;
  ld->msg_id=0;
  ld->ld_version=LDAP_VERSION;
  ld->ld_options=new struct ldapoptions;
  struct ldapoptions *ldo=ld->ld_options;
  ldo->ldo_tm_api=NULL;
  ldo->ldo_tm_net=NULL;
  ldo->ldo_version=LDAP_VERSION2;
  ldo->ldo_deref=LDAP_DEREF_NEVER;
  ldo->ldo_timelimit=0;
  ldo->ldo_sizelimit=0;
  ldo->ldo_defbase=NULL;
  ldo->ldo_defbinddn=NULL;
  ldo->ldo_refhoplimit=0;
  ldo->ldo_valid=LDAP_VALID_SESSION;
  ld->ld_errno=LDAP_SUCCESS; // Let's stay optimistic :-)
  return ld;
}

char * strndup(const char s[],int n) {
  const char *old=s;
  size_t len=(size_t) n ; // Very optimistic...
  if(len < 8) 
    len=8;
  char *nc=new char[len+1];
  //  char *nc=(char *) malloc(len+1);
  if(NULL==nc)
    return NULL;
  nc[n]='\0';
  memcpy(nc,old,n);
  return nc;
}

void ldap_value_free(char **vals){
  char **ptr=vals;
  while(*ptr!=NULL) {
    delete *ptr;
    ptr++;
  }
  delete []vals;
}

void ldap_value_free_len(struct berval **vals){
  struct berval **ptr=vals;
  while(*ptr!=NULL) {
    delete (*ptr)->bv_val; // Mem leak??
    ptr++;
  }
  delete []vals;
}


void ber_bvfree(struct berval *bv){
  if(bv) {
    if (bv->bv_val)
      delete bv->bv_val;
    delete bv;
  }
}

void ber_bvecfree (struct berval **bv){
  ldap_value_free_len(bv);
}


struct berval * ber_bvdup (struct berval *ber) {
  struct berval *bv=new struct berval;
  bv->bv_len=ber->bv_len;
  bv->bv_val=strndup(ber->bv_val,ber->bv_len);  
  return bv;
}
  

void ber_free(BerElement *ber, int fbuf) {
  if(ber)
    delete ber;
}
//
// End of free.cxx
//
