/*
 * Log module for OpenGate
 * 
 * Copyright (c) Tony Genovese 2000
 * Copyright (c) Egoboo Ltd. 2000
 *
 * The contents of this file are subject to the Mozilla Public License
 * Version 1.0 (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS"
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See
 * the License for the specific language governing rights and limitations
 * under the License.
 *
 * The Original Code is RAS Log
 *
 * The Initial Developer of the Original Code is Tony Genovese
 *
 * $Log: Log.h,v $
 * Revision 1.2  2000/05/15 19:03:30  aunitt
 * Added IP address to logging output.
 *
 * Revision 1.1  2000/05/12 14:12:54  aunitt
 * Reworked logging module.
 *
 *
 *
 */


#if !defined(AFX_PRASLOG_H__0BE851A7_613E_4662_A0F8_3C460C279896__INCLUDED_)
#define AFX_PRASLOG_H__0BE851A7_613E_4662_A0F8_3C460C279896__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include <ptlib.h>
#include <ptlib/contain.h>
#include <h225.h>
#include <q931.h>
#include <h245.h>

class OpengateLog
{
public:
    enum Direction
    {
        Sending,
        Receiving
    };

    void LogNote(const PString &Note);
	void LogRasMsg(const H225_RasMessage &          msg,
	               Direction                        Dir,
	               const H225_TransportAddress &    Addr
	              );
	void LogQ931Msg(const Q931 &                msg,
	                Direction                   Dir,
	                const PIPSocket::Address &  Address,
	                WORD                        Port
	               );
	void LogH245Msg(const H245_MultimediaSystemControlMessage & msg,
	                Direction                                   Dir,
   	                const PIPSocket::Address &                  Address,
	                WORD                                        Port
	               );
	
/// define the different trace log levels
    enum Level {
	  //No logging
	  None,
      /// Log message summary only
      Info,     
      /// Log message details
      Trace,
      NumLogLevels
    };
	OpengateLog();
	virtual ~OpengateLog();

protected:
    int GetLogLevel() const { return Cfg.GetInteger( "Level", OpengateLog::None); }
    // Task: to return the current logging level

    void WriteHeader();
    // Task: to write the header information for a log message

    void WriteHeader( Direction Dir );
    // Task: as above including direction....

    void WriteHeader( Direction                     Dir,
                      const PIPSocket::Address &    Address,
                      WORD                          Port
                    );
    // Task: ...and address of sender / receiver

    void WriteHeader( Direction                     Dir,
                      const H225_TransportAddress & Addr
                    );

    void WriteTrailer();
    // Task: to write the trailer for a log message

	PFilePath	LogFilename;
	PTextFile	LogFile;
	PMutex		LogMutex;
	PConfig     Cfg;
};

#endif // !defined(AFX_PRASLOG_H__0BE851A7_613E_4662_A0F8_3C460C279896__INCLUDED_)
