/*************************************************************************/
/**                                                                     **/
/**     getcgivars.c-- routine to read CGI input variables into an      **/
/**         array of strings.                                           **/
/**                                                                     **/
/**     The x2c() and unescape_url() routines were lifted directly      **/
/**     from NCSA's sample program util.c, packaged with their HTTPD.   **/
/**                                                                     **/
/*************************************************************************/

#include "../common/config.h"
#include <stdio.h>
#include <stdlib.h>
#include "getcgi.h"



/* Remove potentially harmful characters from CGI input (Ethan Galstad) */
void sanitize(char **cgivars){
	char *strptr;
	int x,y,i;

	for(strptr=cgivars[i=0];strptr!=NULL;strptr=cgivars[++i]){

		for(x=0,y=0;strptr[x]!='\x0';x++){

			if(strptr[x]==';'||strptr[x]=='|'||strptr[x]=='&'||strptr[x]=='<'||strptr[x]=='>');
			else{
				strptr[y]=strptr[x];
				y++;
			        }
		        }
		strptr[y]='\x0';
	        }

	return;
        }



/** Convert a two-char hex string into the char it represents **/
char x2c(char *what){
	register char digit;

	digit = (what[0] >= 'A' ? ((what[0] & 0xdf) - 'A')+10 : (what[0] - '0'));
	digit *= 16;
	digit += (what[1] >= 'A' ? ((what[1] & 0xdf) - 'A')+10 : (what[1] - '0'));

	return(digit);
        }



/** Reduce any %xx escape sequences to the characters they represent **/
void unescape_url(char *url){
	register int i,j;

	if(url==NULL)
		return;

	for(i=0,j=0;url[j]!='\x0' && j<strlen(url);++i,++j){

		if((url[i]=url[j])=='%'){
			url[i]=x2c(&url[j+1]);
			j+=2;
		        }
	        }
	url[i]='\x0';

	return;
        }



/** Read the CGI input and place all name/val pairs into list.        **/
/** Returns list containing name1, value1, name2, value2, ... , NULL  **/
char **getcgivars(void){
	register int i;
	char *request_method;
	int content_length;
	char *cgiinput;
	char **cgivars;
	char **pairlist;
	int paircount;
	char *nvpair;
	char *eqpos;

	/* initialize char variable(s) */
	cgiinput="";

	/** Depending on the request method, read all CGI input into cgiinput **/
	/** (really should produce HTML error messages, instead of exit()ing) **/

	request_method=getenv("REQUEST_METHOD");
	if(request_method==NULL)
		request_method="";

	if(!strcmp(request_method,"GET") || !strcmp(request_method,"HEAD")){

		/* check for NULL query string environment variable - 04/28/00 (Ludo Bosmans) */
		if(getenv("QUERY_STRING")==NULL){
			cgiinput=(char *)malloc(1);
			if(cgiinput==NULL){
				printf("getcgivars(): Could not malloc for cgiinput.\n");
				exit(1);
			        }
			cgiinput[0]='\x0';
		        }
		else
			cgiinput=strdup(getenv("QUERY_STRING"));
	        }

	else if(!strcmp(request_method,"POST")){

		/* if CONTENT_TYPE variable is not specified, RFC-2068 says we should assume it is "application/octect-string" */
		/* mobile (WAP) stations generate CONTENT_TYPE with charset, we we should only check first 33 chars */
		if(strlen(getenv("CONTENT_TYPE")) && strncasecmp(getenv("CONTENT_TYPE"),"application/x-www-form-urlencoded",33)){
			printf("getcgivars(): Unsupported Content-Type.\n");
			exit(1);
		        }
		if(!(content_length=atoi(getenv("CONTENT_LENGTH")))){
			printf("getcgivars(): No Content-Length was sent with the POST request.\n") ;
			exit(1);
		        }
		if(!(cgiinput=(char *)malloc(content_length+1))){
			printf("getcgivars(): Could not malloc for cgiinput.\n");
			exit(1);
		        }
		if(!fread(cgiinput,content_length,1,stdin)){
			printf("Couldn't read CGI input from STDIN.\n");
			exit(1);
		        }
		cgiinput[content_length]='\0';
	        }
	else{
		printf("getcgivars(): unsupported REQUEST_METHOD -> '%s'\n",request_method);
		printf("\n");
		printf("I'm guessing you're trying to execute the CGI from a command line.\n");
		printf("In order to do that, you need to set the REQUEST_METHOD environment\n");
		printf("variable to either \"GET\", \"HEAD\", or \"POST\".  When using the\n");
		printf("GET and HEAD methods, arguments can be passed to the CGI\n");
		printf("by setting the \"QUERY_STRING\" environment variable.  If you're\n");
		printf("using the POST method, data is read from standard input.  Also of\n");
		printf("note: if you've enabled authentication in the CGIs, you must set the\n");
		printf("\"REMOTE_USER\" environment variable to be the name of the user you're\n");
		printf("\"authenticated\" as.  Now you know the secret.   Just don't tell anyone...\n");
		printf("\n");
		printf("   - Ethan Galstad (netsaint@netsaint.org)\n");
		exit(1);
	        }

	/** Change all plusses back to spaces **/
	for(i=0;cgiinput[i];i++){
		if(cgiinput[i]=='+')
			cgiinput[i]=' ';
	        }

	/** First, split on "&" to extract the name-value pairs into pairlist **/
	pairlist=(char **)malloc(256*sizeof(char **));
	paircount=0;
	nvpair=strtok(cgiinput,"&");
	while(nvpair){
		pairlist[paircount++]=strdup(nvpair);
		if(!(paircount%256))
			pairlist=(char **)realloc(pairlist,(paircount+256)*sizeof(char **));
		nvpair=strtok(NULL,"&");
	        }
	pairlist[paircount]=0;    /* terminate the list with NULL */

	/** Then, from the list of pairs, extract the names and values **/
	cgivars=(char **)malloc((paircount*2+1)*sizeof(char **));
	for(i=0;i<paircount;i++) {
		if((eqpos=strchr(pairlist[i],'='))){
			*eqpos='\0';
			unescape_url(cgivars[i*2+1]=strdup(eqpos+1));
		        } 
		else
			unescape_url(cgivars[i*2+1]=strdup(""));
		unescape_url(cgivars[i*2]=strdup(pairlist[i]));
	        }
	cgivars[paircount*2]=0;   /* terminate the list with NULL */
    
	/** Free anything that needs to be freed **/
	free(cgiinput);
	for(i=0;pairlist[i];i++)
		free(pairlist[i]);
	free(pairlist);

	/* ADDED 3/3/99 Ethan Galstad */
	/* Sanitize the name-value strings */
	sanitize(cgivars);

	/** Return the list of name-value strings **/
	return cgivars;
        }

